//********************************************************
//                                                       /
// Program Assignment: Program 5                         /
// Name:               Pat                  /
// Date:               Auguest 24, 2009                  /
// Description:        This program will output the      /
//                     t-distribution of a students data /
//                     based on equations provided in    /
//                     the Program 5 Assignment Kit.     /
//                                                       /
//********************************************************

// Start Add

#include <stdio.h>
#include <math.h>

#define PI 3.14159265


// *****************************
// *                           *
// *   Function Declarations   *
// *                           *
// *****************************
//

  // Simpsons Rule - Calculate the t-distribution

    float Simpsons_Rule (float t, float num_of_segs,
                          float E, float p1, float dof);


  // Odd_Sum - Calculate the sum of the odd segments

    float Odd_Sum (float num_of_segs, float W, float dof);


  // Odd_Sum - Calculate the sum of the odd segments

    float Even_Sum (float num_of_segs, float W, float dof);


  // Student_t - Calculate the t-distribution at a given x

    float Student_t (float dof, float x);


  // Gamma - Calculate gamma at a given x

    float Gamma (float x);



//********************************************************
//                                                       /
// main                                                  /
//                                                       /
// Description: This is the main function of the program /
//              It provides the necessary input data for /
//              the Simpsons Rule function to calculate  /
//              the t-distribution.                      /
//                                                       /
//******************************************************** 

// Start Part 'main'

// Start Item

int main ()
{
  // Declare the error constant

    const float E = 0.0000001;


  // Test Case 1

    fprintf (stdout, "Test 1:\n  p = %1.5f\n\n",
              Simpsons_Rule (1.1,    10, E, 0, 9));


  // Test Case 2

    fprintf (stdout, "Test 2:\n  p = %1.5f\n\n",
              Simpsons_Rule (1.1812, 10, E, 0, 10));


  // Test Case 3

    fprintf (stdout, "Test 3:\n  p = %1.5f\n\n",
              Simpsons_Rule (2.750,  10, E, 0, 30));


  // Return

    return 0;
}

// End Item

// End Part


//********************************************************
//                                                       /
// Simpson's Rule                                        /
//                                                       /
// Description: This function calculates the             /
//              t-distribution based on the data         /
//              provided by the calling function.        /
//                                                       /
//******************************************************** 

// Start Part 'Simpsons Rule'

// Start Item

float Simpsons_Rule (float t, float num_of_segs, float E, float p1, float dof)
{
  float W, p2;


  // Calculate segment width

    W = t / num_of_segs;


  // Calculate the t-distribution

    p2 = (W / 3) * (Student_t (dof, 0.0) + Odd_Sum (num_of_segs, W, dof) +
                     Even_Sum (num_of_segs, W, dof) + Student_t (dof, t));


  // If the difference in this run and the last run is small enough, return p2

    if (fabs (p1 - p2) < E)
    {
      return p2;
    }

  // The difference was too large, repeat

    else
    {
      return Simpsons_Rule (t, num_of_segs * 2, E, p2, dof);
    }
}

// End Item

// End Part


//********************************************************
//                                                       /
// Sums                                                  /
//                                                       /
// Description: This section contains functions to       /
//              calculate the sums for the even and odd  /
//              segments in the integration.             /
//                                                       /
//******************************************************** 

// Start Part 'Sums'


//**************
//             /
//   Odd_Sum   /
//             /
//**************

// Start Item

float Odd_Sum (float num_of_segs, float W, float dof)
{
  float i, Sum = 0.0;


  // Loop to find the sum of the odd numbers

    for (i = 1.0; i <= num_of_segs - 1.0; i = i + 2.0)
    {
      Sum = Sum + (4.0 * Student_t (dof, i * W));
    }


  // Return the sum

    return Sum;
}

// End Item


//**************
//             /
//   Even_Sum  /
//             /
//**************

// Start Item

float Even_Sum (float num_of_segs, float W, float dof)
{
  float i, Sum = 0.0;

  
  // Loop to find the sum of the even numbers

    for (i = 2.0; i <= num_of_segs - 2.0; i = i + 2.0)
    {
      Sum = Sum + (2.0 * Student_t (dof, i * W));
    }


  // Return the sum

    return Sum;
}

// End Item

// End Part


//********************************************************
//                                                       /
// Student t                                             /
//                                                       /
// Description: This function calculates the             /
//              t-distribution at the point of 'x'.      /
//                                                       /
//******************************************************** 

// Start Part 'Student t'

// Start Item

float Student_t (float dof, float x)
{
  // Calculate the Student t at point 'x' and return

    return (Gamma ((dof + 1) / 2) / (sqrtf (dof * PI) * Gamma (dof / 2)) *
             pow (1 + ((x * x) / dof), (-1 * (dof + 1)) / 2));
}

// End Item

// End Part


//********************************************************
//                                                       /
// Gamma                                                 /
//                                                       /
// Description: This function calculates gamma at the    /
//              point of 'x'.                            /
//                                                       /
//******************************************************** 

// Start Part 'Gamma'

// Start Item

float Gamma (float x)
{
  // If 'x' is greater than 1, continue recursing

    if (x > 1.0)
    {
      return (x - 1) * Gamma (x - 1);
    }

  // If 'x' is 1, we are finished, return 1

    else if (x == 1.0)
    {
      return 1.0;
    }

  // If 'x' is less than 1, it is .5, return the sqaure root of PI

    else
    {
      return sqrtf (PI);
    }
}

// End Item

// End Part

// End Add
